import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { translate } from 'react-i18next';
import { UnavailableContentFollowPanel } from 'ui/containers/follow-panels/unavailable-content-follow-panel';
import { TYPE_DEAD_LTV } from 'state/stream-metadata';
import { PLAYER_FACEBOOK } from 'util/player-type';
import classNames from 'classnames';

const propTypes = {
    t: PropTypes.func.isRequired,
    streamType: PropTypes.string.isRequired,
    hideFollowPanel: PropTypes.bool.isRequired,
};

const mapStateToProps = ({ env, streamMetadata, user }) => ({
    streamType: streamMetadata.streamType,
    hideFollowPanel: (streamMetadata.channel.id === user.id) || (env.playerType === PLAYER_FACEBOOK),
});

const PANEL_CLASS = classNames(
    'pl-pinned-panel',
    'pl-pinned-panel--embed'
);

export function DeadLTVOverlayComponent({ t, hideFollowPanel, streamType }) {
    const FollowComponent = hideFollowPanel ? null : <UnavailableContentFollowPanel />;
    const DeadLTVOverlay = (
        <div className={PANEL_CLASS}>
            <h2 className="pl-pinned-panel__title">
                {t('Live Broadcast has ended')}
            </h2>
            { FollowComponent }
        </div>);

    return streamType === TYPE_DEAD_LTV ? DeadLTVOverlay : null;
}

DeadLTVOverlayComponent.propTypes = propTypes;

export const DeadLTVOverlay = translate()(connect(mapStateToProps)(DeadLTVOverlayComponent));
