import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { purchaseIntentReceived } from 'actions/extensions';
import {
    ExtensionsConfirmation as ExtensionsConfirmationComponent,
    ProductPayloadPropTypes,
} from '../components/extensions-confirmation';
import { LOGGED_IN } from 'state/user';
import I18Next from 'i18next';
import { I18nextProvider } from 'react-i18next';

const propTypes = {
    clearPurchaseIntent: PropTypes.func.isRequired,
    isLinked: PropTypes.bool.isRequired,
    isLoggedIn: PropTypes.bool.isRequired,
    purchaseIntent: PropTypes.shape({
        payload: ProductPayloadPropTypes,
        makePurchase: PropTypes.func.isRequired,
    }),
};

const mapStateToProps = ({ extensions, user }) => {
    const { activeOverlayExtensions, purchaseIntent } = extensions;

    let activeOverlayExtension = null;
    if (purchaseIntent) {
        const extensionName = purchaseIntent.payload.extensionName;
        activeOverlayExtension = activeOverlayExtensions.find(e => e.name === extensionName);
    }

    return {
        isLoggedIn: user.loggedInStatus === LOGGED_IN,
        isLinked: !!(activeOverlayExtension && activeOverlayExtension.lastUserIdentityLinkState),
        purchaseIntent,
    };
};

export const mapDispatchToProps = dispatch => ({
    clearPurchaseIntent() {
        dispatch(purchaseIntentReceived(null));
    },
});

export function ExtensionsConfirmationContainer({
    clearPurchaseIntent,
    isLinked,
    isLoggedIn,
    purchaseIntent,
}) {
    if (!purchaseIntent) {
        return null;
    }

    const { payload, makePurchase } = purchaseIntent;

    function makePurchaseAndReset() {
        clearPurchaseIntent();
        makePurchase();
    }

    function cancel() {
        clearPurchaseIntent();
    }

    return (
        <I18nextProvider i18n={I18Next}>
            <ExtensionsConfirmationComponent
                cancel={cancel}
                confirm={makePurchaseAndReset}
                isLinked={isLinked}
                isLoggedIn={isLoggedIn}
                productPayload={payload}
            />
        </I18nextProvider>
    );
}

ExtensionsConfirmationContainer.propTypes = propTypes;

export const ExtensionsConfirmation = connect(mapStateToProps, mapDispatchToProps)(ExtensionsConfirmationContainer);
