import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { GenericFollowPanelContainer } from 'ui/containers/follow-panels/generic-panel';
import { CenteredFollowPanelContainer } from 'ui/containers/follow-panels/centered-panel';
import { PLAYER_EMBED, PLAYER_POPOUT, PLAYER_SITE,
         PLAYER_PULSE } from 'util/player-type';
import { TYPE_DEAD_LTV } from 'state/stream-metadata';

const propTypes = {
    playerType: PropTypes.string.isRequired,
    streamType: PropTypes.string.isRequired,
};

const mapStateToProps = ({ env, streamMetadata }) => ({
    playerType: env.playerType,
    streamType: streamMetadata.streamType,
});

// eslint-disable-next-line complexity
export function FollowPanelContainer({ playerType, streamType }) {
    // dead ltv streams display their own overlay which includes follow panels
    if (streamType === TYPE_DEAD_LTV) {
        return null;
    }

    switch (playerType) {
    case PLAYER_POPOUT:
    case PLAYER_SITE:
    case PLAYER_EMBED:
        return <GenericFollowPanelContainer />;
    case PLAYER_PULSE:
        return <CenteredFollowPanelContainer />;
    default:
        return null;
    }
}

FollowPanelContainer.propTypes = propTypes;

export const FollowPanel = connect(mapStateToProps)(FollowPanelContainer);
