import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import classNames from 'classnames';
import { hoveringOnUIElement, showUIWithAutoHide } from 'actions/ui';
import { CONTENT_SCREEN } from 'actions/screen';
import { translate } from 'react-i18next';

const propTypes = {
    t: PropTypes.func,
    onHoverElement: PropTypes.func,
    showUIWithAutoHide: PropTypes.func,
    mutedSegmentsAvailable: PropTypes.bool,
    uiShowing: PropTypes.bool,
    isMini: PropTypes.bool,
    isPaused: PropTypes.bool,
    isShowingContentScreen: PropTypes.bool,
};

export const mapStateToProps = ({ timelineMetadata, ui, screen, playback }) => ({
    mutedSegmentsAvailable: timelineMetadata.mutedSegments.length > 0,
    uiShowing: ui.showUI,
    isMini: ui.isMini,
    isShowingContentScreen: screen[0] === CONTENT_SCREEN,
    isPaused: playback.paused,
});

export const mapDispatchToProps = dispatch => ({
    onHoverElement() {
        dispatch(hoveringOnUIElement());
    },

    showUIWithAutoHide() {
        dispatch(showUIWithAutoHide());
    },
});

// eslint-disable-next-line max-len
export const ALERT_MESSAGE = 'Audio for portions of this video has been muted as it appears to contain copyrighted content owned or controlled by a third party.';

export class MutedSegmentsAlertComponent extends React.Component {
    constructor() {
        super(...arguments);
        this.state = { hasDismissedAlert: false };
        this.handleCloseAlertClick = this.handleCloseAlertClick.bind(this);
    }

    // eslint-disable-next-line complexity
    render() {
        const {
            t,
            isShowingContentScreen,
            isMini,
            onHoverElement,
            showUIWithAutoHide,
            mutedSegmentsAvailable,
            uiShowing,
            isPaused,
        } = this.props;
        const { hasDismissedAlert } = this.state;
        const alertClasses = classNames({
            'player-alert': true,
            'muted-alert-on-ui': uiShowing,
        });

        if (
            !mutedSegmentsAvailable ||
            !isShowingContentScreen ||
            hasDismissedAlert ||
            isMini ||
            isPaused
        ) {
            return null;
        }

        return (
            <div
                onMouseEnter={onHoverElement}
                onMouseLeave={showUIWithAutoHide}
                className={alertClasses}
            >
                <p>{t(ALERT_MESSAGE)}</p>
                <button
                    type="button"
                    className="player-button player-button--noscale player-button--close"
                    onClick={this.handleCloseAlertClick}
                >
                    <svg>
                        <use xlinkHref="#icon_close" />
                    </svg>
                </button>
            </div>
        );
    }

    handleCloseAlertClick() {
        this.setState({
            hasDismissedAlert: true,
        });
    }
}

MutedSegmentsAlertComponent.propTypes = propTypes;

// eslint-disable-next-line max-len
export const MutedSegmentsAlert = translate()(connect(mapStateToProps, mapDispatchToProps)(MutedSegmentsAlertComponent));
