import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { removeNotification } from '../../actions/notifications';
import { MENU_STATE_NONE } from 'actions/ui';

const propTypes = {
    i18n: PropTypes.object.isRequired,
    windowObj: PropTypes.object.isRequired,
    notifications: PropTypes.arrayOf(PropTypes.func).isRequired,
    removeCurrentNotification: PropTypes.func,
    currentMenu: PropTypes.string.isRequired,
};

const mapStateToProps = ({ notifications, lang, ui, window: windowObj }) => ({
    notifications,
    i18n: lang,
    currentMenu: ui.showSettings,
    windowObj,
});

const mapDispatchToProps = dispatch => ({
    removeCurrentNotification() {
        dispatch(removeNotification());
    },
});

export class NotificationPopUpsContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.handleClose = this.handleClose.bind(this);
    }

    render() {
        const { notifications, currentMenu } = this.props;

        const isMenuShowing = currentMenu !== MENU_STATE_NONE;

        if (!notifications.length || isMenuShowing) {
            return null;
        }

        const CurrentNotification = notifications[0];

        return (
            <CurrentNotification
                onClose={this.handleClose}
                showNotification={!isMenuShowing}
            />
        );
    }

    handleClose() {
        this.props.removeCurrentNotification();
    }
}

NotificationPopUpsContainer.propTypes = propTypes;

export const NotificationPopUpsWrapper = connect(mapStateToProps, mapDispatchToProps)(NotificationPopUpsContainer);
