import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { AdOverlay as AdOverlayComponent } from 'ui/components/overlays/ad-overlay';

const propTypes = {
    clickThroughUrl: PropTypes.string.isRequired,
    isPartner: PropTypes.bool.isRequired,
    displayName: PropTypes.string.isRequired,
};

export const mapStateToProps = ({ ads, streamMetadata }) => ({
    clickThroughUrl: ads.clickThrough,
    isPartner: streamMetadata.channel.partner,
    displayName: streamMetadata.channel.displayName,
});

export function AdOverlayContainer({ clickThroughUrl, isPartner, displayName }) {
    let adLabel;

    if (isPartner) {
        adLabel = `This Ad supports ${displayName}`;
    } else {
        adLabel = 'Advertisement';
    }

    return (
        <AdOverlayComponent
            clickThroughUrl={clickThroughUrl}
            adLabel={adLabel}
        />
    );
}

AdOverlayContainer.propTypes = propTypes;

export const AdOverlay = connect(mapStateToProps)(AdOverlayContainer);
