import React from 'react';
import PropTypes from 'prop-types';
import { CONNECTED } from 'state/chromecast';
import { connect } from 'react-redux';
import { ChromecastOverlay as ChromecastOverlayComponent } from 'ui/components/overlays/chromecast-overlay';

const propTypes = {
    deviceName: PropTypes.string.isRequired,
    castingState: PropTypes.string.isRequired,
};

const mapStateToProps = ({ chromecast }) => ({
    castingState: chromecast.castingState,
    deviceName: chromecast.deviceName,
});

export function ChromecastOverlayContainer({ deviceName, castingState }) {
    if (castingState !== CONNECTED) {
        return null;
    }

    return <ChromecastOverlayComponent deviceName={deviceName} />;
}

ChromecastOverlayContainer.propTypes = propTypes;
export const ChromecastOverlay = connect(mapStateToProps)(ChromecastOverlayContainer);
