import React from 'react';
import PropTypes from 'prop-types';
import { ErrorOverlay as ErrorOverlayComponent } from 'ui/components/overlays/error-overlay';
import { connect } from 'react-redux';
import { VOD_RESTRICTED_SCREEN } from 'actions/screen';
import Errors from 'errors';

const propTypes = {
    errorCode: PropTypes.number.isRequired,
    errorMessage: PropTypes.string.isRequired,
    hasError: PropTypes.bool.isRequired,
    isVODRestricted: PropTypes.bool.isRequired,
};

export const mapStateToProps = ({ error, screen }) => ({
    errorCode: error.code,
    errorMessage: error.hasError ? Errors.getMessage(error.code) : '',
    hasError: error.hasError,
    isVODRestricted: screen[0] === VOD_RESTRICTED_SCREEN,
});

export function ErrorOverlayContainer({
    hasError,
    errorCode,
    errorMessage,
    isVODRestricted,
}) {
    if (!hasError || hasError && isVODRestricted) {
        return null;
    }

    return (
        <ErrorOverlayComponent
            errorCode={errorCode}
            errorMessage={errorMessage}
        />
    );
}

ErrorOverlayContainer.propTypes = propTypes;
export const ErrorOverlay = connect(mapStateToProps)(ErrorOverlayContainer);
