import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { play } from 'actions/video-api';
import { PlayButtonOverlay as PlayButtonOverlayComponent } from 'ui/components/overlays/play-button-overlay';
import { CONTENT_MODE_VOD } from 'stream/twitch-vod';
import { CONNECTING, CONNECTED } from 'state/chromecast';
import { VOD_RECOMMENDATION_SCREEN, ADVERTISEMENT_SCREEN } from 'actions/screen';
import { OFFLINE_STATUS } from 'state/online-status';
import { SIDEBAR_VIEW } from 'state/collection';

const propTypes = {
    showOverlay: PropTypes.bool.isRequired,
    play: PropTypes.func.isRequired,
    collectionsSidebarOpen: PropTypes.bool.isRequired,
};

export const mapStateToProps = ({
    chromecast,
    collection,
    error,
    playback,
    onlineStatus,
    screen,
    stream,
    ui,
}) => {
    const paused = playback.paused;
    const isMini = ui.isMini;
    const hasError = error.hasError;
    const isOffline = onlineStatus === OFFLINE_STATUS;

    const isEndedVOD = (
        stream.contentType === CONTENT_MODE_VOD &&
        playback.ended
    );

    const isCasting = (
        chromecast.castingState === CONNECTING ||
        chromecast.castingState === CONNECTED
    );

    const isInvalidScreen = (
        screen[0] === VOD_RECOMMENDATION_SCREEN ||
        screen[0] === ADVERTISEMENT_SCREEN
    );

    return {
        collectionsSidebarOpen: collection.currentView === SIDEBAR_VIEW,
        showOverlay: (
            (paused || isEndedVOD) &&
            !isCasting &&
            !isMini &&
            !isInvalidScreen &&
            !hasError &&
            !isOffline
        ),
    };
};

const mapDispatchToProps = dispatch => ({
    play() {
        dispatch(play());
    },
});

export function PlayButtonOverlayContainer({ showOverlay, play, collectionsSidebarOpen }) {
    if (!showOverlay) {
        return null;
    }

    return (
        <PlayButtonOverlayComponent
            onClick={play}
            collectionsSidebarOpen={collectionsSidebarOpen}
        />
    );
}

PlayButtonOverlayContainer.propTypes = propTypes;
export const PlayButtonOverlay = connect(mapStateToProps, mapDispatchToProps)(PlayButtonOverlayContainer);
