import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { pause, play } from 'actions/video-api';
import { toggleFullScreen as toggleFullScreenAction } from 'actions/screen-mode';

const propTypes = {
    isPaused: PropTypes.bool.isRequired,
    playVideo: PropTypes.func.isRequired,
    pauseVideo: PropTypes.func.isRequired,
    toggleFullScreen: PropTypes.func.isRequired,
};

export const mapStateToProps = ({ playback }) => ({
    isPaused: playback.paused,
});

export const mapDispatchToProps = dispatch => ({
    playVideo() {
        dispatch(play());
    },
    pauseVideo() {
        dispatch(pause());
    },
    toggleFullScreen() {
        dispatch(toggleFullScreenAction());
    },
});

export class PlayerClickHandlerOverlayContainer extends Component {
    constructor() {
        super();

        this.onVideoClick = this.onVideoClick.bind(this);
    }

    onVideoClick() {
        const { isPaused, playVideo, pauseVideo } = this.props;

        if (isPaused) {
            playVideo();
        } else {
            pauseVideo();
        }
    }

    render() {
        return (
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            <div
                className="player-overlay"
                onClick={this.onVideoClick}
                onDoubleClick={this.props.toggleFullScreen}
                role="presentation"
            />
        );
    }
}

PlayerClickHandlerOverlayContainer.propTypes = propTypes;

export const PlayerClickHandlerOverlay =
    connect(mapStateToProps, mapDispatchToProps)(PlayerClickHandlerOverlayContainer);
