import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { STORM_WARNING_SCREEN } from 'actions/screen';
import { StormWarningOverlay as StormWarningComponent } from 'ui/components/overlays/storm-warning';

const propTypes = {
    shouldRenderStormWarning: PropTypes.bool.isRequired,
};

const defaultProps = {
    shouldRenderStormWarning: false,
};

export const mapStateToProps = ({ screen }) => ({
    shouldRenderStormWarning: screen[0] === STORM_WARNING_SCREEN,
});

export function StormWarningContainer({ shouldRenderStormWarning }) {
    if (!shouldRenderStormWarning) {
        return null;
    }
    return <StormWarningComponent />;
}

StormWarningContainer.propTypes = propTypes;
StormWarningContainer.defaultProps = defaultProps;
export const StormWarningOverlay = connect(mapStateToProps)(StormWarningContainer);
