import React from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import { twitchHost } from 'settings';
import { contentIsShowing } from 'actions/playback';
import { VOD_RESTRICTED_SCREEN } from 'actions/screen';
import { SubscribeOverlay as SubscribeOverlayComponent } from 'ui/components/overlays/subscribe-overlay';

const propTypes = {
    channelName: PropTypes.string.isRequired,
    contentIsShowing: PropTypes.func.isRequired,
    shouldRenderSubOverlay: PropTypes.bool.isRequired,
};

const defaultProps = {
    shouldRenderSubOverlay: false,
};

const mapStateToProps = ({ screen, streamMetadata }) => ({
    channelName: streamMetadata.channel.name,
    shouldRenderSubOverlay: screen[0] === VOD_RESTRICTED_SCREEN,
});

const mapDispatchToProps = dispatch => ({
    contentIsShowing() {
        dispatch(contentIsShowing());
    },
});

export class SubscribeOverlayContainer extends React.Component {
    constructor() {
        super(...arguments);
    }

    componentDidMount() {
        this.props.contentIsShowing();
    }

    render() {
        const { channelName, shouldRenderSubOverlay } = this.props;
        if (shouldRenderSubOverlay) {
            const subscribeUrl = `${twitchHost}/${channelName}/subscribe?ref=chansub_overlay_subscribe`;
            return (
                <SubscribeOverlayComponent
                    channelName={channelName}
                    subscribeUrl={subscribeUrl}
                />
            );
        }
        return null;
    }
}

SubscribeOverlayContainer.propTypes = propTypes;
SubscribeOverlayContainer.defaultProps = defaultProps;
export const SubscribeOverlay = connect(mapStateToProps, mapDispatchToProps)(SubscribeOverlayContainer);
