import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import * as PlayerType from 'util/player-type';
import { toggleFullScreen } from 'actions/screen-mode';
import { ADVERTISEMENT_SCREEN } from 'actions/screen';
import { ToggleFullscreen } from 'ui/components/overlays/toggle-fullscreen-overlay';

const propTypes = Object.freeze({
    trackEvent: PropTypes.func,
    isFullScreen: PropTypes.bool,
    shouldRenderFullscreenOverlay: PropTypes.bool,
    toggleFullScreen: PropTypes.func,
    isAd: PropTypes.bool,
    showUI: PropTypes.bool,
});

const defaultProps = Object.freeze({
    trackEvent() {},
    toggleFullScreen() {},
});

export const mapStateToProps = ({ analyticsTracker, env, screen, screenMode, ui }) => ({
    trackEvent: analyticsTracker.trackEvent,
    isFullScreen: !screenMode.isFullScreen,
    shouldRenderFullscreenOverlay: env.playerType !== PlayerType.PLAYER_FRONTPAGE &&
                                    env.playerType !== PlayerType.PLAYER_FEED,
    isAd: screen[0] === ADVERTISEMENT_SCREEN,
    showUI: ui.showUI,
});

export const mapDispatchToProps = dispatch => ({
    toggleFullScreen() {
        dispatch(toggleFullScreen());
    },
});

export class ToggleFullscreenContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.handleDoubleClick = this.handleDoubleClick.bind(this);
    }

    handleDoubleClick() {
        const {
            trackEvent,
            isFullScreen,
            toggleFullScreen,
        } = this.props;

        trackEvent('player_click_fullscreen', {
            action: !isFullScreen,
        });

        toggleFullScreen();
    }

    render() {
        const { shouldRenderFullscreenOverlay, isAd, showUI } = this.props;
        if (!shouldRenderFullscreenOverlay || isAd || showUI) {
            return null;
        }
        return (
            <ToggleFullscreen
                handleDoubleClick={this.handleDoubleClick}
            />
        );
    }
}

ToggleFullscreenContainer.propTypes = propTypes;
ToggleFullscreenContainer.defaultProps = defaultProps;
export const ToggleFullscreenOverlay = connect(mapStateToProps, mapDispatchToProps)(ToggleFullscreenContainer);
