import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { hideUI, showUIWithAutoHide } from 'actions/ui';

const propTypes = {
    children: PropTypes.node.isRequired,
    hideUI: PropTypes.func.isRequired,
    paused: PropTypes.bool.isRequired,
    root: PropTypes.object.isRequired,
    showUIWithAutoHide: PropTypes.func.isRequired,
};

const mapStateToProps = ({ playback }) => ({
    paused: playback.paused,
});

export const mapDispatchToProps = dispatch => ({
    showUIWithAutoHide() {
        dispatch(showUIWithAutoHide());
    },

    hideUI() {
        dispatch(hideUI());
    },
});

export class PlayerRootContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.showAndAutoHide = this._showAndAutoHide.bind(this);
        this.hide = this._hide.bind(this);
    }

    componentDidMount() {
        this.props.root.addEventListener('mouseenter', this.showAndAutoHide);
        this.props.root.addEventListener('mousemove', this.showAndAutoHide);
        this.props.root.addEventListener('mouseleave', this.hide);
    }

    componentWillUnmount() {
        this.props.root.removeEventListener('mouseenter', this.showAndAutoHide);
        this.props.root.removeEventListener('mousemove', this.showAndAutoHide);
        this.props.root.removeEventListener('mouseleave', this.hide);
    }

    render() {
        return (
            <div className="player-root">
                {this.props.children}
            </div>
        );
    }

    _showAndAutoHide() {
        if (!this.props.paused) {
            this.props.showUIWithAutoHide();
        }
    }

    _hide() {
        if (!this.props.paused) {
            this.props.hideUI();
        }
    }
}

PlayerRootContainer.propTypes = propTypes;

export const PlayerRoot = connect(mapStateToProps, mapDispatchToProps)(PlayerRootContainer);
