import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { PlaybackSpeedMenu as PlaybackSpeedMenuComponent } from 'ui/components/settings/playback-speed-menu';
import { changePlaybackRate } from 'actions/video-api';
import { showMenu, MENU_STATE_NONE } from 'actions/ui';

const propTypes = {
    currentSpeed: PropTypes.number.isRequired,
    onMenuTransition: PropTypes.func,
    selectNewPlaybackRate: PropTypes.func,
    tracker: PropTypes.object,
};

const defaultProps = {
    onMenuTransition() {},
    selectNewPlaybackRate() {},
    tracker: {
        trackEvent() {},
    },
};

const mapStateToProps = ({ analyticsTracker, playback }) => ({
    currentSpeed: playback.playbackRate,
    tracker: analyticsTracker,
});

export const mapDispatchToProps = dispatch => ({
    selectNewPlaybackRate(playbackRate) {
        dispatch(changePlaybackRate(playbackRate));
        dispatch(showMenu(MENU_STATE_NONE));
    },
});

export class PlaybackSpeedMenuContainer extends React.Component {
    constructor() {
        super(...arguments);

        this.handleSelectPlaybackRate = this.handleSelectPlaybackRate.bind(this);
    }

    handleSelectPlaybackRate(speed) {
        const { selectNewPlaybackRate, tracker } = this.props;

        tracker.trackEvent('player_click_playback', {
            speed,
        });

        selectNewPlaybackRate(speed);
    }

    render() {
        const {
            currentSpeed,
            onMenuTransition,
        } = this.props;

        return (
            <PlaybackSpeedMenuComponent
                currentSpeed={currentSpeed}
                onMenuTransition={onMenuTransition}
                onSelectPlaybackSpeed={this.handleSelectPlaybackRate}
            />
        );
    }
}

PlaybackSpeedMenuContainer.propTypes = propTypes;
PlaybackSpeedMenuContainer.defaultProps = defaultProps;

export const PlaybackSpeedMenu = connect(mapStateToProps, mapDispatchToProps)(PlaybackSpeedMenuContainer);
