import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { QualityMenu as QualityMenuComponent } from 'ui/components/settings/quality-menu';
import { selectQuality, setPreferredQuality } from 'actions/quality';
import { showMenu, MENU_STATE_NONE } from 'actions/ui';
import { trackEvent } from 'actions/analytics-tracker';

const propTypes = {
    availableQualities: PropTypes.array.isRequired,
    selectedQuality: PropTypes.string.isRequired,
    onMenuTransition: PropTypes.func,
    handleSelectQuality: PropTypes.func,
};

const defaultProps = {
    onMenuTransition() {},
    handleSelectQuality() {},
};

const mapStateToProps = ({ quality }) => ({
    availableQualities: quality.available,
    selectedQuality: quality.selected,
});

export const mapDispatchToProps = dispatch => ({
    handleSelectQuality(qualityObj) {
        dispatch(selectQuality(qualityObj.group));
        dispatch(setPreferredQuality(qualityObj));
        dispatch(showMenu(MENU_STATE_NONE));
        dispatch(trackEvent('player_click_quality_change'));
    },
});

export const QualityMenuContainer = ({
    availableQualities,
    selectedQuality,
    handleSelectQuality,
    onMenuTransition,
}) => {
    return (
        <QualityMenuComponent
            availableQualities={availableQualities}
            selectedQuality={selectedQuality}
            onMenuTransition={onMenuTransition}
            onQualitySelect={handleSelectQuality}
        />
    );
};

QualityMenuContainer.propTypes = propTypes;
QualityMenuContainer.defaultProps = defaultProps;

export const QualityMenu = connect(mapStateToProps, mapDispatchToProps)(QualityMenuContainer);
