import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { ReportIssuesMenu as ReportIssuesMenuComponent,
         REPORT_FEEDBACK_DELAY } from 'ui/components/settings/report-issues-menu';
import { submitVideoIssueReport } from 'actions/video-api';
import { showMenu, MENU_STATE_NONE } from 'actions/ui';

const propTypes = {
    handleVideoIssueReport: PropTypes.func,
    hideSettingsMenu: PropTypes.func,
    onMenuTransition: PropTypes.func,
    windowObj: PropTypes.object.isRequired,
};

const defaultProps = {
    handleVideoIssueReport() {},
    hideSettingsMenu() {},
    onMenuTransition() {},
};

const mapStateToProps = ({ window }) => ({
    windowObj: window,
});

export const mapDispatchToProps = dispatch => ({
    handleVideoIssueReport(value) {
        dispatch(submitVideoIssueReport(value));
    },
    hideSettingsMenu() {
        dispatch(showMenu(MENU_STATE_NONE));
    },
});

export class ReportIssuesMenuContainer extends React.Component {
    constructor() {
        super(...arguments);

        this.handleVideoIssueReport = this.handleVideoIssueReport.bind(this);
    }

    handleVideoIssueReport(value) {
        this.props.handleVideoIssueReport(value);
        this.props.windowObj.setTimeout(() => {
            this.props.hideSettingsMenu();
        }, REPORT_FEEDBACK_DELAY);
    }

    render() {
        const { onMenuTransition, windowObj } = this.props;

        return (
            <ReportIssuesMenuComponent
                onMenuTransition={onMenuTransition}
                onReportIssueSubmit={this.handleVideoIssueReport}
                windowObj={windowObj}
            />
        );
    }
}

ReportIssuesMenuContainer.propTypes = propTypes;
ReportIssuesMenuContainer.defaultProps = defaultProps;

export const ReportIssuesMenu = connect(mapStateToProps, mapDispatchToProps)(ReportIssuesMenuContainer);
