import PropTypes from 'prop-types';
import React from 'react';
import { connect } from 'react-redux';
import { StaffMenu as StaffMenuComponent } from 'ui/components/settings/staff-menu';
import { requestAds, AdRollTypes, DEFAULT_AD_DURATION } from 'actions/ads';

const propTypes = {
    onMenuTransition: PropTypes.func,
    onRunLocalPrerollAd: PropTypes.func.isRequired,
    onRunLocalMidrollAd: PropTypes.func.isRequired,
    onRunLocalPostrollAd: PropTypes.func.isRequired,
};

const defaultProps = {
    onMenuTransition() {},
};

export const mapDispatchToProps = dispatch => ({
    onRunLocalPrerollAd() {
        dispatch(requestAds(AdRollTypes.PREROLL, DEFAULT_AD_DURATION, true));
    },

    onRunLocalMidrollAd() {
        dispatch(requestAds(AdRollTypes.MIDROLL, DEFAULT_AD_DURATION, true));
    },

    onRunLocalPostrollAd() {
        dispatch(requestAds(AdRollTypes.POSTROLL, DEFAULT_AD_DURATION, true));
    },
});

export const StaffMenuContainer = ({
    onMenuTransition,
    onRunLocalPrerollAd,
    onRunLocalMidrollAd,
    onRunLocalPostrollAd,
}) => {
    return (
        <StaffMenuComponent
            onMenuTransition={onMenuTransition}
            onRunLocalPrerollAd={onRunLocalPrerollAd}
            onRunLocalMidrollAd={onRunLocalMidrollAd}
            onRunLocalPostrollAd={onRunLocalPostrollAd}
        />
    );
};

StaffMenuContainer.propTypes = propTypes;
StaffMenuContainer.defaultProps = defaultProps;

export const StaffMenu = connect(null, mapDispatchToProps)(StaffMenuContainer);
