import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { Stats as StatsComponent } from '../../components/stats/stats';
import { displayStats } from 'actions/stats';
import { CONTENT_MODE_LIVE } from 'stream/twitch-live';

const propTypes = {
    stats: PropTypes.shape({
        bufferSize: PropTypes.number,
        displayResolution: PropTypes.string,
        skippedFrames: PropTypes.number,
        fps: PropTypes.number,
        hlsLatencyBroadcaster: PropTypes.number,
        hlsLatencyEncoder: PropTypes.number,
        memoryUsage: PropTypes.string,
        playbackRate: PropTypes.number,
        videoResolution: PropTypes.string,
        backendVersion: PropTypes.string,
    }).isRequired,
    isLive: PropTypes.bool.isRequired,
    displayed: PropTypes.bool.isRequired,
    closeStats: PropTypes.func.isRequired,
};

export const mapStateToProps = ({ stats, stream }) => ({
    isLive: stream.contentType === CONTENT_MODE_LIVE,
    displayed: stats.displayed,
    stats: stats.videoStats,
});

export const mapDispatchToProps = dispatch => ({
    closeStats() {
        dispatch(displayStats(false));
    },
});

export class StatsContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.onClose = this.onClose.bind(this);
    }

    onClose() {
        this.props.closeStats();
    }

    render() {
        const {
            isLive,
            displayed,
            stats,
        } = this.props;

        if (!displayed) {
            return null;
        }

        return (
            <StatsComponent
                isLive={isLive}
                onClose={this.onClose}
                stats={stats}
            />
        );
    }
}

StatsContainer.propTypes = propTypes;
export const Stats = connect(mapStateToProps, mapDispatchToProps)(StatsContainer);
