import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { PLAYER_AMAZON_VSE } from 'util/player-type';

const propTypes = {
    children: PropTypes.node.isRequired,
    showTopBar: PropTypes.bool.isRequired,
};

// TODO: create amazon vse player type and remove this
export const mapStateToProps = ({ env, ui }) => ({
    showTopBar: env.playerType !== PLAYER_AMAZON_VSE && !ui.isMini,
});

export function TopBarContainer({ children, showTopBar }) {
    if (!showTopBar) {
        return null;
    }

    return (
        <div className="pl-controls-top js-controls-top">
            {children}
        </div>
    );
}

TopBarContainer.propTypes = propTypes;
export const TopBar = connect(mapStateToProps)(TopBarContainer);
