import * as PlayerType from '../util/player-type';
import { toggleFullScreen } from '../actions/screen-mode';

export function PlayerUIControls(root, store, opts) {
    const unsubscribes = [];

    function init() {
        const options = opts;
        initDom(options);

        root.setAttribute('data-theatre', false);
        root.setAttribute('data-showinfo', options.showInfo);
    }

    function initDom(options) {
        if (options.player !== PlayerType.PLAYER_FRONTPAGE && options.player !== PlayerType.PLAYER_FEED) {
            root.getElementsByClassName('js-control-fullscreen-overlay')[0].
                addEventListener('dblclick', onFullScreenOverlayDblClick);
        }
    }

    function onToggleFullscreen() {
        const { analyticsTracker, screenMode } = store.getState();

        analyticsTracker.trackEvent('player_click_fullscreen', {
            action: !screenMode.isFullScreen,
        });

        store.dispatch(toggleFullScreen());
    }

    function onFullScreenOverlayDblClick(e) {
        e.preventDefault();
        onToggleFullscreen();
    }

    this.destroy = function() {
        root.getElementsByClassName('js-control-fullscreen-overlay')[0].
            removeEventListener('dblclick', onFullScreenOverlayDblClick);

        unsubscribes.forEach(unsub => unsub());
    };

    init();
}
