import * as PlayerType from '../util/player-type';
import { subscribe } from '../util/subscribe';
import { emitOpenStream } from 'actions/event-emitter';

export function PlayerUIInfo(player, root, store, options) {
    let unsubscribes = [];

    function init() {
        unsubscribes.push(
            subscribe(
                store,
                ['screenMode.isFullScreen', 'screenMode.isTheatreMode'],
                checkShowInfo
            )
        );
        checkShowInfo();

        const playerType = options.player;

        if (playerType) {
            root.setAttribute('data-playertype', playerType);
        }

        if (playerType === PlayerType.PLAYER_FRONTPAGE || playerType === PlayerType.PLAYER_FEED) {
            root.getElementsByClassName('js-control-fullscreen-overlay')[0].
                addEventListener('click', onOpenStreamClick);
        }
        unsubscribes.push(subscribe(store, ['viewercount'], function({ viewercount }) {
            root.setAttribute('data-viewers', viewercount);
        }));

        unsubscribes.push(subscribe(store, ['screen'], function({ screen }) {
            root.setAttribute('data-screen', screen[0]);
        }));

        unsubscribes.push(subscribe(store, ['streamMetadata'], onStreamMetadata));
    }

    function onOpenStreamClick() {
        store.dispatch(emitOpenStream());
    }

    function onStreamMetadata() {
        if (player.getVideo()) {
            root.setAttribute('data-video', player.getVideo());
        } else {
            root.removeAttribute('data-video');
        }
    }

    function checkShowInfo() {
        const { screenMode } = store.getState();
        if (options.showInfo || screenMode.isTheatreMode || screenMode.isFullScreen) {
            root.setAttribute('data-showinfo', true);
        } else {
            root.setAttribute('data-showinfo', false);
        }
    }

    this.destroy = function() {
        root.getElementsByClassName('js-control-fullscreen-overlay')[0].
            removeEventListener('click', onOpenStreamClick);

        unsubscribes.forEach(unsub => unsub());
        unsubscribes = null;
    };

    init();
}
