import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { PLAYER_AMAZON_LIVE, PLAYER_CLIPS_VIEWING, PLAYER_CLIPS_EMBED } from 'util/player-type';

const propTypes = {
    playerType: PropTypes.string.isRequired,
    player: PropTypes.object.isRequired,
    root: PropTypes.object.isRequired,
};

const mapStateToProps = ({ env }) => ({
    playerType: env.playerType,
});

export class PlayerTypeLoaderComponent extends React.Component {
    constructor() {
        super(...arguments);
        this._setPlayerTypeComponent = this._setPlayerTypeComponent.bind(this);
        this.state = {
            playerTypeComponent: null,
        };
    }

    componentWillMount() {
        this._setPlayerTypeComponent(this.props.playerType);
    }

    componentWillReceiveProps({ playerType }) {
        if (this.props.playerType !== playerType) {
            this._setPlayerTypeComponent(playerType);
        }
    }

    render() {
        if (!this.state.playerTypeComponent) return null;
        return (
            <this.state.playerTypeComponent player={this.props.player} root={this.props.root} />
        );
    }

    // Note: We can't turn the require.ensure into a method,
    // webpack needs the strings to create the assets.
    _setPlayerTypeComponent(playerType) {
        switch (playerType) {
        case PLAYER_AMAZON_LIVE:
            return require.ensure([], () => {
                const playerTypeComponent = require('ui/player-types/amazon-live/default');
                this.setState({
                    playerTypeComponent: playerTypeComponent.default,
                });
            }, 'amazonLivePlayerType');
        case PLAYER_CLIPS_VIEWING:
            return require.ensure([], () => {
                const playerTypeComponent = require('ui/player-types/clips/viewing');
                this.setState({
                    playerTypeComponent: playerTypeComponent.default,
                });
            }, 'clipsViewingPlayerType');
        case PLAYER_CLIPS_EMBED:
            return require.ensure([], () => {
                const playerTypeComponent = require('ui/player-types/clips/embed');
                this.setState({
                    playerTypeComponent: playerTypeComponent.default,
                });
            }, 'clipsEmbedPlayerType');
        default:
            return require.ensure([], () => {
                const playerTypeComponent = require('ui/player-types/default/default');
                this.setState({
                    playerTypeComponent: playerTypeComponent.default,
                });
            }, 'defaultPlayerType');
        }
    }
}

PlayerTypeLoaderComponent.propTypes = propTypes;

export const PlayerTypeLoader = connect(mapStateToProps)(PlayerTypeLoaderComponent);
