import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { Button } from 'ui/components/buttons/base-button';
import { translate } from 'react-i18next';
import { ShareSVG } from 'ui/player-types/clips/common/svg/share';
import { pushScreen, CLIP_SHARING_SCREEN } from 'actions/screen';

const propTypes = {
    t: PropTypes.func.isRequired,
    showSharing: PropTypes.func.isRequired,
};

const mapDispatchToProps = dispatch => ({
    showSharing() {
        dispatch(pushScreen(CLIP_SHARING_SCREEN));
    },
});

export const ShareButtonComponent = ({ showSharing, t }) => {
    return (
        <Button
            className={'player-button'}
            onClick={showSharing}
        >
            <span>
                <span className="player-tip player-tip--aright" data-tip={t('Share')} />
                <ShareSVG />
            </span>
        </Button>
    );
};

ShareButtonComponent.propTypes = propTypes;

export const ShareButton = translate()(connect(null, mapDispatchToProps)(ShareButtonComponent));
