import React from 'react';
import PropTypes from 'prop-types';
import * as Timestamp from 'util/timestamp';

const propTypes = {
    currentTime: PropTypes.number,
    duration: PropTypes.number,
};

export const ClipsSeekbarTimeDisplay = ({ currentTime, duration }) => {
    const formattedRemainingTime = Timestamp.toString(duration - currentTime, true);

    return (
        <div className="player-seek__time-container">
            <span className="player-seek__time player-seek__time--total">
                {formattedRemainingTime}
            </span>
        </div>
    );
};

ClipsSeekbarTimeDisplay.propTypes = propTypes;
