/* globals Image:false */
import React, { Component } from 'react';
import PropTypes from 'prop-types';

const defaultProps = {
    className: '',
};

const propTypes = {
    src: PropTypes.string.isRequired,
    altSrc: PropTypes.string.isRequired,
    className: PropTypes.string,
    alt: PropTypes.string.isRequired,
};

export class ImageFallback extends Component {
    constructor(props) {
        super(props);

        this.state = { src: props.src };
        this.setImage = this.setImage.bind(this);
    }

    componentDidMount() {
        if (this.props.src) {
            this.setImage(this.props);
        }
    }

    componentWillReceiveProps(nextProps) {
        if (nextProps.src !== this.props.src) {
            this.setImage(nextProps);
        }
    }

    setImage({ src, altSrc }) {
        const image = new Image();

        image.onerror = () => this.setState({ src: altSrc });
        image.onload = () => this.setState({ src: src });
        image.src = src;
    }

    render() {
        return <img src={this.state.src} className={this.props.className} alt={this.props.alt} />;
    }
}

ImageFallback.defaultProps = defaultProps;
ImageFallback.propTypes = propTypes;
