import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    value: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    id: PropTypes.string.isRequired,
    onSelect: PropTypes.func.isRequired,
};

export function SelectableInput({ value, label, id, onSelect }) {
    function onClickHandler(event) {
        onSelect();
        event.target.select();
    }

    return (
        <div className="form__group pl-pd-y-05 cs-form pl-flex__item--grow">
            <label htmlFor={`input-clip-${id}`} className="form__label pd-b-1">{label}</label>
            <input
                id={`input-clip-${id}`}
                className="pl-form__input cs-form__input"
                type="text"
                onClick={onClickHandler}
                value={value}
                readOnly={true}
            />
        </div>
    );
}

SelectableInput.propTypes = propTypes;
