import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    broadcasterDisplayName: PropTypes.string.isRequired,
    channelURL: PropTypes.string.isRequired,
};

export const BroadcasterLink = ({ broadcasterDisplayName, channelURL }) => (
    <a
        target="_blank"
        className="broadcaster-info__name-link"
        rel="nofollow noopener noreferrer"
        href={channelURL}
    >
        { broadcasterDisplayName }
    </a>
);

BroadcasterLink.propTypes = propTypes;
