import React from 'react';
import PropTypes from 'prop-types';
import { Interpolate, translate } from 'react-i18next';
import { BroadcasterLink } from 'ui/player-types/clips/overlays/clip-info-overlay/broadcaster-link';
import { GameLink } from 'ui/player-types/clips/overlays/clip-info-overlay/game-link';

const defaultProps = {
    game: '',
    gameUrl: '',
};

const propTypes = {
    broadcasterDisplayName: PropTypes.string.isRequired,
    channelURL: PropTypes.string.isRequired,
    game: PropTypes.string,
    gameUrl: PropTypes.string,
};

export const BroadcasterPlayingGameLinkComponent = ({ broadcasterDisplayName, channelURL, game, gameUrl }) => {
    const broadcasterLink = (
        <BroadcasterLink
            broadcasterDisplayName={broadcasterDisplayName}
            channelURL={channelURL}
        />
    );

    if (!game) {
        return broadcasterLink;
    }

    return (
        <Interpolate
            i18nKey={'{{displayName}} playing {{game}}'}
            displayName={broadcasterLink}
            game={<GameLink game={game} gameLink={gameUrl} />}
        />
    );
};

BroadcasterPlayingGameLinkComponent.defaultProps = defaultProps;
BroadcasterPlayingGameLinkComponent.propTypes = propTypes;

export const BroadcasterPlayingGameLink = translate()(BroadcasterPlayingGameLinkComponent);
