import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    game: PropTypes.string.isRequired,
    gameLink: PropTypes.string.isRequired,
};

export const GameLink = ({ game, gameLink }) => (
    <a
        target="_blank"
        className="broadcaster-info__game-link"
        rel="nofollow noopener noreferrer"
        href={gameLink}
    >
        { game }
    </a>
);

GameLink.propTypes = propTypes;
