import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import {
    ClipKeyboardShortcutsOverlay,
} from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/clip-keyboard-shortcuts-overlay';
import { popScreen, CLIP_SHORTCUT_SCREEN } from 'actions/screen';

const propTypes = {
    closeShortcutsPanel: PropTypes.func.isRequired,
    shouldShowShortcutsPanel: PropTypes.bool.isRequired,
};

const mapStateToProps = ({ screen }) => ({
    shouldShowShortcutsPanel: screen[0] === CLIP_SHORTCUT_SCREEN,
});

const mapDispatchToProps = dispatch => ({
    closeShortcutsPanel() {
        dispatch(popScreen());
    },
});

export const ClipKeyboardShortcutsOverlayContainerComponent = props => {
    if (!props.shouldShowShortcutsPanel) {
        return null;
    }

    return <ClipKeyboardShortcutsOverlay {...props} />;
};

ClipKeyboardShortcutsOverlayContainerComponent.propTypes = propTypes;

export const ClipKeyboardShortcutsOverlayContainer = (
    connect(mapStateToProps, mapDispatchToProps)(ClipKeyboardShortcutsOverlayContainerComponent)
);
