import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { CloseButtonSVG } from 'ui/player-types/clips/common/svg/close-button';
import { ShortcutRow } from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/shortcut-row';

const propTypes = {
    closeShortcutsPanel: PropTypes.func.isRequired,
    t: PropTypes.func.isRequired,
};

export const ClipKeyboardShortcutsOverlayComponent = ({ closeShortcutsPanel, t }) => (
    <div className="pl-panel-overlay pl-flex">
        <div className="pl-panel__header pl-flex pl-flex--verticalCenter full-width">
            <div className="pl-panel__header-title pl-flex__item--grow">
                {t('Keyboard Shortcuts')}
            </div>
            <div className="pl-panel__header-action pl-flex__item--noGrow">
                <button className="pl-button pl-button--text pl-button--icon-only pd-0" onClick={closeShortcutsPanel} >
                    <figure className="pl-panel__icon">
                        <CloseButtonSVG />
                    </figure>
                </button>
            </div>
        </div>
        <div className="pl-panel__body full-width">
            <ShortcutRow label={t('Pause/Play')} value={t('Space')} />
            <ShortcutRow label={t('Back/Forward {{count}} second', { count: 2 })} value="←" valueAlt="→" />
            <ShortcutRow label={t('Back/Forward 1 frame')} value="[" valueAlt="]" />
            <ShortcutRow label={t('Slow down/Speed up')} value="<" valueAlt=">" />
            <ShortcutRow label={t('Toggle Fullscreen')} value="f" />
            <ShortcutRow label={t('Exit Fullscreen')} value={t('Esc')} />
            <ShortcutRow label={t('Show this menu')} value="?" />
        </div>
    </div>
);

ClipKeyboardShortcutsOverlayComponent.propTypes = propTypes;

export const ClipKeyboardShortcutsOverlay = translate()(ClipKeyboardShortcutsOverlayComponent);
