import React from 'react';
import PropTypes from 'prop-types';

const propTypes = {
    label: PropTypes.string.isRequired,
    value: PropTypes.string.isRequired,
    valueAlt: PropTypes.string,
};

export const ShortcutRow = ({ label, value, valueAlt }) => {
    let panelValue = value;

    if (valueAlt) {
        panelValue = (
            <span>
                {value}
                <span className="pl-panel__row-muted-value">/</span>
                {valueAlt}
            </span>
        );
    }

    return (
        <div className="pl-panel__body-row pl-flex flex--verticalCenter">
            <div className="pl-panel__row-key pl-flex__item--grow">{label}</div>
            <div className="pl-panel__row-value pl-flex__item--noGrow">{panelValue}</div>
        </div>
    );
};

ShortcutRow.propTypes = propTypes;
