import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { play } from 'actions/video-api';
import { PlayButtonOverlay as PlayButtonOverlayComponent } from 'ui/components/overlays/play-button-overlay';

const propTypes = {
    showOverlay: PropTypes.bool.isRequired,
    play: PropTypes.func.isRequired,
};

export const mapStateToProps = ({ playback }) => ({
    showOverlay: !playback.hasPlayed && !playback.isLoading,
});

const mapDispatchToProps = dispatch => ({
    play() {
        dispatch(play());
    },
});

export function ClipPlayButtonOverlayContainer({ showOverlay, play }) {
    if (!showOverlay) {
        return null;
    }

    return (
        <PlayButtonOverlayComponent
            onClick={play}
        />
    );
}

ClipPlayButtonOverlayContainer.propTypes = propTypes;
export const ClipPlayButtonOverlay = connect(mapStateToProps, mapDispatchToProps)(ClipPlayButtonOverlayContainer);
