import React from 'react';
import PropTypes from 'prop-types';
import { translate } from 'react-i18next';
import { connect } from 'react-redux';
import { SocialLinkHelper } from 'ui/player-types/clips/utils/social-link-helper';
import { popScreen, CLIP_SHARING_SCREEN } from 'actions/screen';
import { ClipShareOverlay } from 'ui/player-types/clips/overlays/clip-share-overlay/clip-share-overlay';

function ClipShareOverlayContainerComponent({ clipUrl, hideSharing, shouldShow, clipEmbedUrl, analyticsTracker }) {
    if (!shouldShow) {
        return null;
    }

    return (
        <ClipShareOverlay
            clipUrl={clipUrl}
            hideSharing={hideSharing}
            clipEmbedUrl={clipEmbedUrl}
            analyticsTracker={analyticsTracker}
        />
    );
}

ClipShareOverlayContainerComponent.propTypes = {
    clipUrl: PropTypes.string.isRequired,
    hideSharing: PropTypes.func.isRequired,
    shouldShow: PropTypes.bool.isRequired,
    clipEmbedUrl: PropTypes.string.isRequired,
    analyticsTracker: PropTypes.object.isRequired,
};

const mapStateToProps = ({ streamMetadata, analyticsTracker, screen }) => ({
    clipUrl: streamMetadata.url,
    clipEmbedUrl: SocialLinkHelper.generateEmbedScript(streamMetadata.embedUrl),
    shouldShow: screen[0] === CLIP_SHARING_SCREEN,
    analyticsTracker,
});

const mapDispatchToProps = dispatch => ({
    hideSharing() {
        dispatch(popScreen());
    },
});

export const ClipShareOverlayContainer = translate()(
    connect(mapStateToProps, mapDispatchToProps)(ClipShareOverlayContainerComponent)
);
