import React, { Component }  from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { SocialLinkHelper } from 'ui/player-types/clips/utils/social-link-helper';
import { translate } from 'react-i18next';
import classNames from 'classnames';

function openShareWindow({ broadcaster, clipUrl, companyName, clipTitle, t, localWindow }) {
    const socialData = SocialLinkHelper.socialListenerData(
        broadcaster,
        clipUrl,
        companyName,
        clipTitle,
        t
    );

    localWindow.open(socialData.url, socialData.windowName, socialData.newWindowOptions);
}

const defaultProps = {
    onClick: () => {},
};

const propTypes = {
    companySVG: PropTypes.object.isRequired,
    companyName: PropTypes.string.isRequired,
    broadcaster: PropTypes.object.isRequired,
    clipUrl: PropTypes.string.isRequired,
    clipTitle: PropTypes.string,
    localWindow: PropTypes.object.isRequired,
    onClick: PropTypes.func,
    t: PropTypes.func.isRequired,
};

const mapStateToProps = ({ streamMetadata, window: localWindow }) => ({
    broadcaster: streamMetadata.channel,
    clipUrl: streamMetadata.url,
    clipTitle: streamMetadata.title,
    localWindow,
});

export class ShareIconComponent extends Component {
    constructor() {
        super();

        this.onClickHandler = this.onClickHandler.bind(this);
    }

    onClickHandler() {
        this.props.onClick(this.props.companyName);
        openShareWindow(this.props);
    }

    render() {
        const BUTTON_CLASSES = classNames({
            // eslint-disable-next-line camelcase
            flex__item: true,
            'share-icon': true,
            'cs-icon': true,
            [this.props.companyName]: true,
        });

        return (
            <button
                className={BUTTON_CLASSES}
                onClick={this.onClickHandler}
            >
                {this.props.companySVG}
            </button>
        );
    }
}

ShareIconComponent.propTypes = propTypes;
ShareIconComponent.defaultProps = defaultProps;

export const ShareIcon = translate() (
    connect(mapStateToProps)(ShareIconComponent)
);
