import {
    TRACKING_MEDIUM_EMBED,
    TRACKING_PROPERTY_EMBED_CLIP_REC,
} from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';
import { ttAnalyticsQuery, Links } from 'ui/player-types/clips/utils/link-helper';
import { getRecommendedClipsForSlug } from 'state/clip-recommendations';
import { broadcasterLiveStatus, broadcasterStream } from 'state/broadcaster-info';
import { BROADCASTER_IS_LIVE } from 'actions/broadcaster-info';
import { toURLString } from 'util/timestamp';

export const ITEM_TYPE_CLIP = 'clip';
export const ITEM_TYPE_VOD = 'vod';
export const ITEM_TYPE_LIVE = 'live_channel';

function urlWithTrackingParams(url, trackingName) {
    if (!url) {
        return '';
    }

    return ttAnalyticsQuery(url, TRACKING_MEDIUM_EMBED, trackingName);
}

function liveStreamUrlSelector(state) {
    return urlWithTrackingParams(
        broadcasterStream(state, state.streamMetadata.channel.name).channel.url,
        'recommend_stream_link'
    );
}

function liveStreamImageUrlSelector(state) {
    return urlWithTrackingParams(
        broadcasterStream(state, state.streamMetadata.channel.name).preview.medium,
        'recommend_stream_img'
    );
}

function vodUrlSelector({ streamMetadata: { clipVideoId, clipVideoOffset } }) {
    return urlWithTrackingParams(
        Links.default.getVodLink(clipVideoId, toURLString(clipVideoOffset)),
        'recommend_vod_link'
    );
}

// TODO - add support for vod previewImageUrl in clips api
function vodImageUrlSelector({ streamMetadata: { clipVideoPreviewImageUrl } }) {
    return urlWithTrackingParams(clipVideoPreviewImageUrl, 'recommend_vod_img');
}

const vodPostPlayDataSelector = state => ({
    itemType: ITEM_TYPE_VOD,
    linkUrl: vodUrlSelector(state),
    imageUrl: vodImageUrlSelector(state),
    title: '', // TODO**
    itemId: state.streamMetadata.clipVideoId,
    viewCount: null,
    channel: state.streamMetadata.channel.name,
    displayName: state.streamMetadata.channel.displayName,
    game: state.streamMetadata.game,
});

const livePostPlayDataSelector = state => ({
    itemType: ITEM_TYPE_LIVE,
    linkUrl: liveStreamUrlSelector(state),
    imageUrl: liveStreamImageUrlSelector(state),
    title: '', // TODO**
    itemId: state.streamMetadata.channel.name,
    viewCount: null,
    channel: state.streamMetadata.channel.name,
    displayName: state.streamMetadata.channel.displayName,
    game: state.streamMetadata.game,
});

const singleClipPostPlayData = (
    { id, url, thumbnails: { medium }, viewCount, game, title, channel: { name, displayName } }
) => ({
    itemType: ITEM_TYPE_CLIP,
    linkUrl: urlWithTrackingParams(url, TRACKING_PROPERTY_EMBED_CLIP_REC),
    imageUrl: medium,
    title,
    itemId: id,
    viewCount: viewCount,
    channel: name,
    displayName: displayName,
    game,
});

const recommendedClipsPostPlayDataSelector = (state, rawMaxCount) => {
    const recommendedClips = getRecommendedClipsForSlug(state, state.streamMetadata.slug);
    const maxCount = Math.min(rawMaxCount, recommendedClips.length);
    const desiredRecommendedClips = recommendedClips.slice(0, maxCount);

    return desiredRecommendedClips.map(singleClipPostPlayData);
};

export const postPlayContentDataSelector = (state, maxCount) => {
    const broadcasterIsLive = broadcasterLiveStatus(state, state.streamMetadata.channel.name) === BROADCASTER_IS_LIVE;

    const channelContent = [
        broadcasterIsLive ? livePostPlayDataSelector(state) : null,
        state.streamMetadata.clipHasVod ? vodPostPlayDataSelector(state) : null,
    ].filter(content => Boolean(content));

    return [
        ...channelContent,
        ...recommendedClipsPostPlayDataSelector(state, maxCount - channelContent.length),
    ];
};
