import { stringify, parse } from 'query-string';
import assign from 'lodash/assign';
import { twitchHost } from 'settings';

const fullTwitchHost = `https:${twitchHost}`;

export function withQueryParams(url, newQueryParams = {}) {
    if (!url || !url.split) {
        return url;
    }

    const [newUrl, oldQueryParamsString] = url.split('?');
    if (oldQueryParamsString) {
        const oldQueryParams = parse(oldQueryParamsString);
        const nextQueryParams = stringify(assign({}, oldQueryParams, newQueryParams));

        return `${newUrl}?${nextQueryParams}`;
    }

    const nextQueryParams = stringify(newQueryParams);
    return `${newUrl}?${nextQueryParams}`;
}

// eslint-disable-next-line camelcase
export function ttAnalyticsQuery(url, tt_medium, tt_content) {
    return withQueryParams(url, {
        // eslint-disable-next-line camelcase
        tt_medium,
        // eslint-disable-next-line camelcase
        tt_content,
    });
}

export const Links = {
    default: {
        getGameLink(game) {
            return `${fullTwitchHost}/directory/game/${encodeURIComponent(game)}`;
        },

        getClipsOnGamePageLink(game) {
            return `${Links.default.getGameLink(game)}/clips`;
        },

        getClipsOnChannelPageLink(channelName) {
            return `${fullTwitchHost}/${channelName}/clips`;
        },
        getVodLink: (vodId, vodOffset) => {
            return `${fullTwitchHost}/videos/${vodId}?t=${vodOffset}`;
        },
    },

    android: {
        getChannelLink(broadcasterLogin, fallbackUrl) {
            // eslint-disable-next-line
            return `intent://stream/${broadcasterLogin}#Intent;scheme=twitch;package=tv.twitch.android.app;S.browser_fallback_url=${fallbackUrl};end`;
        },
    },
};
