export class NumberFormatter {
    constructor(value) {
        this._value = value;
    }

    get hasAbbreviation() {
        return this.abbreviation !== '';
    }

    get abbreviation() {
        if (this._value > 1000000) {
            return 'm';
        }
        return this._value > 1000 ? 'k' : '';
    }

    inThousands(decimalPrecision = 0) {
        if (this._value < 1000) {
            return parseFloat(this._value);
        }
        if (this._value > 1000000) {
            return this.constructor.decimalFormat(this._value / 1000000, decimalPrecision);
        }

        return this.constructor.decimalFormat(this._value / 1000, decimalPrecision);
    }

    inCommas() {
        return this._value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
    }

    toShortString(decimalPrecision = 0) {
        if (this._value < 1000) {
            return this._value.toString();
        }

        const decimalValue = this.inThousands(decimalPrecision);
        return `${decimalValue}${this.abbreviation}`;
    }

    static decimalFormat(value, decimalPrecision = 0) {
        return parseFloat(value).toFixed(decimalPrecision);
    }
}
