import { cleanCondense } from 'ui/player-types/clips/utils/string-formatter';
import { TRACKING_MEDIUM_EMBED } from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';
import { withQueryParams } from 'ui/player-types/clips/utils/link-helper';

export const HASHTAG_CLIPS = '#twitchclips';

const SOCIAL_SHARE_NAME = 'Social Share';
const TWEET_CHARACTER_LIMIT = 140;

// https://support.twitter.com/articles/78124
// Twitter's URL shortener always results in a length 23 URL
// Even if the original link is shorter than 23 characters.
const TWEET_URL_CHARACTER_BUFFER = 23;

export const SocialLinkHelper = {
    socialListenerData: (broadcaster, clipUrl, socialSite, clipTitle, t) => {
        const socialLinkData = SocialLinkHelper.getSocialShareData(broadcaster, clipUrl, clipTitle, t);
        const { url, width, height } = socialLinkData[socialSite];

        const newWindowOptions = (width && height) ?
            `status = 1, width = ${width}, height = ${height}, resizable = 0` :
            null;

        const windowName = SOCIAL_SHARE_NAME;

        return {
            url,
            windowName,
            newWindowOptions,
        };
    },

    getSocialShareData: (broadcaster, clipUrl, clipTitle, t) => {
        const redditCaption = SocialLinkHelper.formatShareText(
            SocialLinkHelper.generateCaption(broadcaster, clipTitle, t)
        );
        const twitterCaption = SocialLinkHelper.formatShareText(
            SocialLinkHelper.generateCaption(broadcaster, clipTitle, t),
            SocialLinkHelper.generateTwitterSuffix(broadcaster),
            TWEET_CHARACTER_LIMIT - TWEET_URL_CHARACTER_BUFFER
        );

        /* eslint-disable camelcase */
        const facebookUrl = encodeURIComponent(withQueryParams(clipUrl, { tt_medium: 'fb' }, true));
        const twitterUrl = encodeURIComponent(withQueryParams(clipUrl, { tt_medium: 'twtr' }, true));
        const redditUrl = encodeURIComponent(withQueryParams(clipUrl, { tt_medium: 'redt' }, true));
        /* eslint-enable camelcase */

        return {
            facebook: {
                url: `https://www.facebook.com/sharer/sharer.php?u=${facebookUrl}`,
                width: 560,
                height: 656,
            },
            twitter: {
                url: `http://www.twitter.com/share?text=${twitterCaption}&url=${twitterUrl}`,
                width: 845,
                height: 443,
            },
            reddit: {
                url: `http://www.reddit.com/submit?title=${redditCaption}&url=${redditUrl}`,
            },
        };
    },

    generateEmbedScript(clipEmbedUrl) {
        const embedUrlWithParams = withQueryParams(clipEmbedUrl, {
            autoplay: 'false',
            // eslint-disable-next-line camelcase
            tt_medium: TRACKING_MEDIUM_EMBED,
        });

        return `<iframe src="${embedUrlWithParams}"` +
            ' width="640" height="360" frameborder="0" scrolling="no" allowfullscreen="true"></iframe>';
    },

    generateCaption: (broadcaster, title, t) => {
        if (title !== '') {
            return title;
        }

        // eslint-disable-next-line quotes
        return t(`Check out this clip from {{displayName}}'s broadcast`, {
            displayName: broadcaster.displayName,
        });
    },

    generateTwitterSuffix: broadcaster => {
        const atBroadcaster = broadcaster.twitterLogin ? ` @${broadcaster.twitterLogin}` : '';

        return ` ${HASHTAG_CLIPS}${atBroadcaster} `;
    },

    formatShareText: (message = '', suffix = '', maxLength = Infinity) => {
        let newMessage = message;
        const charactersForMessage = maxLength - suffix.length;

        if (newMessage.length > charactersForMessage) {
            newMessage = `${cleanCondense(newMessage, charactersForMessage - 3)}...`;
        }

        return encodeURIComponent(cleanCondense(`${newMessage}${suffix}`));
    },
};
