const SPACE = ' ';
const EMPTY_STRING = '';

/**
 * Takes a string, optional max length. Returns a condensed version of the string
 * See tests for more details.
 *
 * example:
 *   assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 6), 'hey');
 *   assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 7), 'hey you');
 *
 * @param {string} str
 * @param {int} maxLength
 * @return {string}
 */
export function cleanCondense(rawString, maxLength = Infinity) {
    const filteredString = rawString.replace(/\s+/g, SPACE).trim();
    const splitLastWord = /\S/.test(filteredString[maxLength] || EMPTY_STRING) &&
        /\S/.test(filteredString[maxLength - 1] || EMPTY_STRING);

    const trimmedString = filteredString.substring(0, maxLength).trim();
    const moreThanOneWord = trimmedString.indexOf(SPACE) >= 0;

    if (splitLastWord && moreThanOneWord) {
        const splitString = trimmedString.split(SPACE);
        return splitString.slice(0, splitString.length - 1).join(SPACE);
    }

    return trimmedString;
}
