import { LOGGED_IN } from 'state/user';
import { PLAYER_CLIPS_EMBED } from 'util/player-type';
import { getSessionId } from 'ui/player-types/clips/utils/tracking/tab-session-id';
import {
    TRACKING_MEDIUM_EMBED,
    TRACKING_LOCATION_CLIPS,
    TRACKING_PROPERTY_ITEM_TYPE,
    TRACKING_PROPERTY_CAROUSEL_CONTENT,
    TRACKING_PROPERTY_CONTENT_MAP,
} from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';
import { parse } from 'util/params';
import { getFirstValidCategory } from 'state/clip-recommendations';
import { broadcasterLiveStatus, broadcasterPartnerStatus } from 'state/broadcaster-info';
import { BROADCASTER_IS_LIVE, BROADCASTER_IS_PARTNER, NOT_AVAILABLE } from 'actions/broadcaster-info';

export const TRACKING_VOD_TYPE = 'clip';

const urlParams = ({ window: windowObj }) => parse(windowObj.location.search.slice(1));

/* eslint-disable camelcase */
export const clipsBaseProperties = state => ({
    tab_session_id: getSessionId(),
    content: urlParams(state).tt_content,
    medium: urlParams(state).tt_medium,
    logged_in: state.user.loggedInStatus === LOGGED_IN,
    login: state.user.name,
    user_id: state.user.id ? parseInt(state.user.id, 10) : null,
    received_language: state.lang,
    vod_type: TRACKING_VOD_TYPE,
    client_time: state.window.Date.now() / 1000,
    location: TRACKING_MEDIUM_EMBED, // TODO: update when other clips players are live
    live: false,
    time: null,
});

export const clipsClipProperties = state => {
    const broadcasterName = state.streamMetadata.channel.name;

    let isLive;
    let isPartner;
    const liveState = broadcasterLiveStatus(state, broadcasterName);
    const partnerState = broadcasterPartnerStatus(state, broadcasterName);

    if (liveState !== NOT_AVAILABLE) {
        isLive = liveState === BROADCASTER_IS_LIVE;
    }
    if (partnerState !== NOT_AVAILABLE) {
        isPartner = partnerState === BROADCASTER_IS_PARTNER;
    }

    return {
        channel: state.streamMetadata.channel.name || null,
        channel_id: state.streamMetadata.channel.id ? parseInt(state.streamMetadata.channel.id, 10) : null,
        game: state.streamMetadata.game || null,
        partner: isPartner,
        live: isLive,
        player: state.env.playerType === PLAYER_CLIPS_EMBED ? TRACKING_MEDIUM_EMBED : TRACKING_LOCATION_CLIPS,
        vod_id: parseInt(state.streamMetadata.id, 10),
    };
};

export const clipsRecommendationProperties = state => {
    const content = TRACKING_PROPERTY_CONTENT_MAP[getFirstValidCategory(state, state.streamMetadata.slug)];

    return {
        source_channel: state.streamMetadata.channel.name || null,
        source_game: state.streamMetadata.game || null,
        source_vod_id: parseInt(state.streamMetadata.id, 10),
        source_item_type: TRACKING_PROPERTY_ITEM_TYPE,
        content: content ? content : null,
        carousel_content: TRACKING_PROPERTY_CAROUSEL_CONTENT,
    };
};
/* eslint-enable camelcase */
