import { TRACKING_CLIPS_MINUTE } from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';
import { MinutesWatched, EVENT_MINUTE } from 'util/minutes-watched';
import { UIStateSubscriber } from 'ui/state-subscriber';

export const SECONDS_TO_MILLIS_MULT = 1000;

export class ClipsMinutesWatched extends UIStateSubscriber {
    constructor(store) {
        super();

        this.store = store;
        this.trackClipsMinuteWatched = this.trackClipsMinuteWatched.bind(this);
        this.handlePlaybackChange = this.handlePlaybackChange.bind(this);

        this.minWatchedEmitter = new MinutesWatched();
        this.minWatchedEmitter.on(EVENT_MINUTE, this.trackClipsMinuteWatched);

        this.subscribe(store, ['playback'], ({ playback }) => {
            this.handlePlaybackChange(playback);
        });

        this.handlePlaybackChange(store.getState());
    }

    handlePlaybackChange(playback) {
        const currentlyTracking = this.minWatchedEmitter.isCurrentlyTracking();

        if (!currentlyTracking && playback.playing) {
            this.minWatchedEmitter.start();
        } else if (currentlyTracking && playback.paused) {
            this.minWatchedEmitter.stop();
        }
    }

    trackClipsMinuteWatched() {
        this.store.getState().analyticsTracker.clipsTrackEvent(
            TRACKING_CLIPS_MINUTE,
            {
                /* eslint-disable camelcase */
                minutes_logged: this.minWatchedEmitter.totalMinutes,
                seconds_offset: this.minWatchedEmitter.initialDelay / SECONDS_TO_MILLIS_MULT,
                /* eslint-enable camelcase */
            }
        );
    }

    destroy() {
        this.minWatchedEmitter.destroy();
    }
}
