import { generate } from 'util/unique-id';

export const TAB_SESSION_ID_KEY = 'clips_rec_sid';

export const getSessionId = () => {
    let tabSessionId;

    try {
        tabSessionId = window.sessionStorage.getItem(TAB_SESSION_ID_KEY);
        if (!tabSessionId) {
            tabSessionId = generate();
        }
        window.sessionStorage.setItem(TAB_SESSION_ID_KEY, tabSessionId);
    } catch (e) {
        tabSessionId = null;
    }

    return tabSessionId;
};
