import React from 'react';
import PropTypes from 'prop-types';
import { LoadingOverlay } from 'ui/containers/overlays/loading-overlay';
import { BottomControls } from 'ui/containers/bottom-controls';
import { PLAYER_CLIPS_VIEWING } from 'util/player-type';
import { PlayerUIControls } from 'ui/controls';
import { PlayerUIInfo } from 'ui/info';
import { PlayerRoot } from 'ui/containers/player-root';
import { ShowOnHover } from 'ui/containers/common/show-on-hover';
import { ClipsLoadingTimeSpentTracker } from 'ui/player-types/clips/utils/tracking/clips-loading-time-spent-tracker';
import { ClipsMinutesWatched } from 'ui/player-types/clips/utils/tracking/clips-minutes-watched';
import { PlayerClickHandlerOverlay } from 'ui/containers/overlays/player-click-handler-overlay';
import { ClipPlayButtonOverlay } from 'ui/player-types/clips/overlays/clip-play-button-overlay-container';
import {
    ClipKeyboardShortcutsOverlayContainer,
} from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/clip-keyboard-shortcuts-overlay-container';
require ('./styles/clips-player.sass');

const contextTypes = {
    store: PropTypes.object.isRequired,
};

const propTypes = {
    player: PropTypes.object.isRequired,
    root: PropTypes.object.isRequired,
};

export default class ClipsViewingPlayer extends React.Component {
    constructor() {
        super(...arguments);
    }

    componentDidMount() {
        const { player, root } = this.props;
        const store = this.context.store;
        const options = {
            player: PLAYER_CLIPS_VIEWING,
        };

        // Root DOM element.
        root.classList.add('player', 'theme--dark');
        root.insertAdjacentHTML('beforeend', require('html-loader!./html/clips.html'));

        const uiInfo = new PlayerUIInfo(player, root, store, options);
        const uiControls = new PlayerUIControls(root, store, options);
        const loadingTimeSpentTracker = new ClipsLoadingTimeSpentTracker(store, player);
        const minWatchTracker = new ClipsMinutesWatched(store);

        this.setState({
            playerProcesses: [
                uiInfo,
                uiControls,
                loadingTimeSpentTracker,
                minWatchTracker,
            ],
        });
    }

    componentWillUnmount() {
        this.state.playerProcesses.forEach(uiController => {
            uiController.destroy();
        });
    }

    render() {
        return (
            <div
                id="clips_viewing"
            >
                {/* Players are assumed to have double click behavior so it breaks without the below */}
                <div className="js-control-fullscreen-overlay" />
                <ClipPlayButtonOverlay />
                <PlayerClickHandlerOverlay />
                <ClipKeyboardShortcutsOverlayContainer />
                <LoadingOverlay />
                <PlayerRoot root={this.props.root}>
                    <ShowOnHover>
                        <BottomControls getCurrentTime={this.props.player.getCurrentTime} />
                    </ShowOnHover>
                </PlayerRoot>
            </div>
        );
    }
}

ClipsViewingPlayer.contextTypes = contextTypes;
ClipsViewingPlayer.propTypes = propTypes;
