import React from 'react';
import includes from 'lodash/includes';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { I18nextProvider } from 'react-i18next';
import { I18N_INSTANCE } from '../lang/i18n';
import { PlayerUI } from './main';
import { PlayerTypeLoader } from './player-type-loader';
import { PLAYER_AMAZON_LIVE, PLAYER_CLIPS_VIEWING, PLAYER_CLIPS_EMBED } from 'util/player-type';

const ASYNC_PLAYER_TYPES = Object.freeze([
    PLAYER_AMAZON_LIVE,
    PLAYER_CLIPS_VIEWING,
    PLAYER_CLIPS_EMBED,
]);

const DESTRUCTIBLE = Object.freeze({ destroy() {} });

export function uiLoader(
    video,
    root,
    store,
    clipGenerator,
    options
) {
    const mountPoint = document.createElement('div');
    mountPoint.classList.add('player-ui');
    root.appendChild(mountPoint);

    if (includes(ASYNC_PLAYER_TYPES, options.player)) {
        ReactDOM.render(
            <Provider store={store}>
                <I18nextProvider i18n={I18N_INSTANCE}>
                    <PlayerTypeLoader player={video} root={root} />
                </I18nextProvider>
            </Provider>,
            mountPoint
        );
        return DESTRUCTIBLE;
    }

    return new PlayerUI(video, root, store, clipGenerator, options);
}
