import { userLoggedIn, userNotLoggedIn } from './actions/user';
import { oauthToken, krakenUserInfo } from './api';

const KRAKEN_USER_TYPE_STAFF = 'staff';

export class UserManager {
    constructor(store) {
        this._store = store;
        this.updateUserInfo();
    }

    updateUserInfo() {
        oauthToken().
        then(krakenUserInfo).
        then(this._normalizeUserInfo).
        then(info => this._store.dispatch(userLoggedIn(info))).
        catch(() => this._store.dispatch(userNotLoggedIn()));
    }

    _normalizeUserInfo(krakenUserResponse) {
        return {
            id: krakenUserResponse._id,
            name: krakenUserResponse.name,
            isStaff: krakenUserResponse.type === KRAKEN_USER_TYPE_STAFF,
        };
    }

    destroy() {}
}
