export const ONE_HOUR_IN_MS = 60 * 60 * 1000;

/**
 * Converts a duration of time in milliseconds to an object expressing the human-readable time format
 *
 * @param {Integer} Duration of time in milliseconds
 * @return {Object} time counters (hours, minutes, secs) and the corresponding amount for each for human-readable format
 */
export function toHumanReadable(milliseconds) {
    const seconds = Math.floor(milliseconds / 1000);
    const minutes = Math.floor(seconds / 60);
    const hours = Math.floor(minutes / 60);
    return {
        hours,
        minutes: minutes % 60,
        seconds: seconds % 60,
    };
}

/**
 * Converts a duration of time in seconds to a translated string of the form "5 hours and 22 minutes"
 *
 * @param {Integer} Duration of time in seconds
 * @param {Object} Language translation object
 * @return {Object} translated string of the form "5 hours and 22 minutes"
 */
export function toHumanTime(lengthSecs, lang) {
    const humanReadable = toHumanReadable(lengthSecs * 1000);

    const minutesText = lang.translate('{{count}} minute', {
        count: humanReadable.minutes,
    });
    const hoursText = lang.translate('{{count}} hour', {
        count: humanReadable.hours,
    });

    if (humanReadable.hours === 0) {
        return minutesText;
    } else if (humanReadable.minutes === 0) {
        return hoursText;
    }

    return lang.translate('{{hoursText}} and {{minutesText}}', {
        hoursText,
        minutesText,
    });
}
