import assign from 'lodash/assign';
import * as PlayerType from 'util/player-type';

export const EXTENSION_PERMISSION_STATE_NONE = 'none';
export const EXTENSION_PERMISSION_STATE_GRANTED = 'granted';

export const EXTENSION_ROLE_VIEWER = 'viewer';
export const EXTENSION_ROLE_BROADCASTER = 'broadcaster';

export const EXTENSION_MENU_MAIN = 'main menu';
export const EXTENSION_MENU_DETAILS = 'extension details';
export const EXTENSION_MENU_MANAGE_ACCESS = 'extension manage access';
export const EXTENSION_MENU_REPORT = 'extension report';

export const EXTENSION_HIDDEN_ANCHOR = 'hidden';

const DEFAULT_TOKEN = {
    permissionsState: EXTENSION_PERMISSION_STATE_NONE,
    role: EXTENSION_ROLE_VIEWER,
};

export const EXTENSIONLESS_PLAYER_TYPES = {
    [PlayerType.PLAYER_CURSE]: true,
    [PlayerType.PLAYER_FRONTPAGE]: true,
    [PlayerType.PLAYER_FEED]: true,
    [PlayerType.PLAYER_FACEBOOK]: true,
    [PlayerType.PLAYER_HIGHLIGHTER]: true,
    [PlayerType.PLAYER_PULSE]: true,
    [PlayerType.PLAYER_TWITCH_EVERYWHERE]: true,
    [PlayerType.PLAYER_AMAZON_VSE]: true,
};

export function parseExtensionToken(token) {
    if (!token) {
        return DEFAULT_TOKEN;
    }

    try {
        const payload = JSON.parse(atob(token.split('.')[1]));
        const isLinked = !!(payload && payload.user_id);
        const { role } = payload;
        const permissionsState = isLinked ? EXTENSION_PERMISSION_STATE_GRANTED : EXTENSION_PERMISSION_STATE_NONE;
        return assign({}, DEFAULT_TOKEN, {
            token,
            permissionsState,
            role,
        });
    } catch (e) {
        // eslint-disable-next-line no-console
        console.error('Error parsing extension token', e);
    }

    return assign({}, DEFAULT_TOKEN, {
        token,
    });
}
