import swfobject from 'exports-loader?swfobject!swfobject-npm/swfobject/src/swfobject';

export function getFlashPlayerVersion() {
    return swfobject.getFlashPlayerVersion();
}

export function hasFlashPlayerVersion(version) {
    return swfobject.hasFlashPlayerVersion(version);
}

export function hasFlashPlayer() {
    // Reports version 0.0.0 when Flash is missing.
    return hasFlashPlayerVersion('1');
}

export function getFlashPlayerType() {
    var type = 'application/x-shockwave-flash';
    var mimeTypes = navigator.mimeTypes;

    if (mimeTypes && mimeTypes[type] && mimeTypes[type].enabledPlugin) {
        var filename = mimeTypes[type].enabledPlugin.filename;
        if (filename.match(/pepflashplayer|Pepper/gi)) {
            return 'ppapi';
        }
        return 'npapi';
    } else if (hasFlashPlayer()) {
        // TODO Does this ever happen?
        return 'unknown';
    }
    // No Flash enabled.
    return '';
}

/* eslint-disable max-len */
export function embedSWF(url, elementId, width, height, swfVersionStr, xiSwfUrlStr, flashvars, params, attributes, callback) {
    return swfobject.embedSWF(url, elementId, width, height, swfVersionStr, xiSwfUrlStr, flashvars, params, attributes, callback);
}
/* eslint-enable max-len */

/**
 * Removes a specific SWFObject element ID from the DOM.
 *
 * @param {String} The ID of the element to remove.
 */
export function removeSWF(elementId) {
    return swfobject.removeSWF(elementId);
}
